IF EXISTS (SELECT  * FROM SYS.TRIGGERS WHERE NAME = 'TRG_EST_NF_ENT_EST_PED_VD_INCLUI_PENDENCIA')
BEGIN
	DROP TRIGGER TRG_EST_NF_ENT_EST_PED_VD_INCLUI_PENDENCIA
END 
GO 


CREATE TRIGGER [dbo].[TRG_EST_NF_ENT_EST_PED_VD_INCLUI_PENDENCIA] ON [dbo].[EST_NF_ENT_EST_PED_VD]
FOR INSERT
AS
     DELETE FROM p
     FROM EST_PED_VD_PENDENCIA p
     WHERE EXISTS
     (
         SELECT *
         FROM INSERTED
         WHERE CD_EMP = p.CD_EMP
               AND CD_FILIAL = p.CD_FILIAL
               AND CD_PED = p.CD_PED
     );
     --Pendencia de entrada pre-faturas transferencias (SEPARADO NO ESTOQUE)
     INSERT INTO EST_PED_VD_PENDENCIA
     (CD_EMP, 
      CD_FILIAL, 
      CD_PED, 
      CD_FILIAL_DEST, 
      FLAG_REALIZAR_FAT
     )
            SELECT DISTINCT p.CD_EMP, 
                   p.CD_FILIAL, 
                   p.CD_PED, 
                   0, 
                   ISNULL(v.FLAG_REALIZAR_FAT, 0) AS FLAG_REALIZAR_FAT
            FROM INSERTED p
                 INNER JOIN EST_PED_VD v ON p.CD_EMP = v.CD_EMP
                                            AND p.CD_FILIAL = v.CD_FILIAL
                                            AND p.CD_PED = v.CD_PED
            WHERE v.STS_PED <> 2
                  AND NOT EXISTS
            (
                SELECT *
                FROM EST_NF_SAI_PED_VD nf
                WHERE p.CD_EMP = nf.CD_EMP
                      AND p.CD_FILIAL = nf.CD_FILIAL
                      AND p.CD_PED = nf.CD_PED
            )
                  AND NOT EXISTS
            (
                SELECT *
                FROM EST_PED_VD_PENDENCIA PX
                WHERE PX.CD_EMP = p.CD_EMP
                      AND PX.CD_FILIAL = p.CD_FILIAL
                      AND PX.CD_PED = p.CD_PED
            );

